<?php
session_start();

if (!isset($_SESSION['panel_logged_in']) || $_SESSION['panel_logged_in'] !== true) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'No autorizado']);
    exit;
}

header('Content-Type: application/json');

$sessionsFile = __DIR__ . "/sessions.json";
$ipColorsFile = __DIR__ . "/ip_colors.json";

$success = true;
$message = '';

if (file_put_contents($sessionsFile, json_encode([], JSON_PRETTY_PRINT)) === false) {
    $success = false;
    $message = 'Error al limpiar sesiones';
} else {
    // Reiniciar el contador de colores
    if (file_exists($ipColorsFile)) {
        $resetColorData = [
            'global_counter' => 0,
            'counters' => [
                '🔵' => 0,
                '🔴' => 0,
                '🟢' => 0,
                '🟡' => 0,
                '🟣' => 0
            ]
        ];
        file_put_contents($ipColorsFile, json_encode($resetColorData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    }
    $message = 'Todos los registros han sido eliminados';
}

echo json_encode(['success' => $success, 'message' => $message]);
