<?php
session_start();
header('Content-Type: application/json');

$sid = $_SESSION['sid'] ?? '';
$sessionsFile = __DIR__ . "/sessions.json";

if (!$sid) {
    echo json_encode(['success' => false, 'message' => 'No session ID found']);
    exit;
}

$sessions = file_exists($sessionsFile) ? json_decode(file_get_contents($sessionsFile), true) : [];

if (isset($sessions[$sid])) {
    $sessions[$sid]['timestamp'] = time();
    $sessions[$sid]['active'] = true;
    
    if (file_put_contents($sessionsFile, json_encode($sessions, JSON_PRETTY_PRINT)) !== false) {
        echo json_encode(['success' => true, 'timestamp' => time()]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Error saving data']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Session not found']);
}
