<?php
session_start();
header('Content-Type: application/json');

$sid = $_SESSION['sid'] ?? '';
$sessionsFile = __DIR__ . "/sessions.json";

if (!$sid) {
    echo json_encode(['success' => false, 'message' => 'No session ID found']);
    exit;
}

// Actualizar sesión con bloqueo atómico
$fp = fopen($sessionsFile, "c+");
if ($fp) {
    if (flock($fp, LOCK_EX)) {
        // Leer archivo dentro del bloqueo
        rewind($fp);
        $content = stream_get_contents($fp);
        $sessions = $content ? json_decode($content, true) : [];
        
        if (!is_array($sessions)) {
            $sessions = [];
        }
        
        if (isset($sessions[$sid])) {
            $sessions[$sid]['active'] = false;
            $sessions[$sid]['timestamp'] = time() - 100;
            
            // Escribir archivo
            ftruncate($fp, 0);
            rewind($fp);
            fwrite($fp, json_encode($sessions, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
            fflush($fp);
            
            flock($fp, LOCK_UN);
            fclose($fp);
            
            echo json_encode(['success' => true]);
        } else {
            flock($fp, LOCK_UN);
            fclose($fp);
            echo json_encode(['success' => false, 'message' => 'Session not found']);
        }
    } else {
        fclose($fp);
        echo json_encode(['success' => false, 'message' => 'Error al bloquear archivo']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Error saving data']);
}
